unit Files;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     Controls, 
     Buttons,
     StdCtrls,
     ExtCtrls,
     Nwtools,
     NWServer,
     Nwlib, NWprint, Menus;

type
  TwinFile = class(TForm)
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Panel1: TPanel;
    SalvageList: TListBox;
    Header1: THeader;
    NWServer1: TNWServer;
    NWTools1: TNWTools;
    NWLib1: TNWLib;
    Bevel2: TBevel;
    Panel2: TPanel;
    fileList: TListBox;
    Header2: THeader;
    bSalvage: TButton;
    Bevel3: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    fileOwner: TEdit;
    fileCreated: TEdit;
    fileModified: TEdit;
    fileSize: TEdit;
    deleteDate: TEdit;
    deleteBy: TEdit;
    fileUpdated: TEdit;
    archiveBy: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    delFileInfoBtn: TButton;
    fileInfoBtn: TButton;
    dirPath: TEdit;
    Label9: TLabel;
    bRefresh: TButton;
    ncopyBtn: TButton;
    NWPrint1: TNWPrint;
    nPrintBtn: TButton;
    purgeBtn: TButton;
    filePopup: TPopupMenu;
    FlagFile1: TMenuItem;
    DeleteFile1: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure bSalvageClick(Sender: TObject);
    procedure delFileInfoBtnClick(Sender: TObject);
    procedure fileInfoBtnClick(Sender: TObject);
    procedure bRefreshClick(Sender: TObject);
    procedure SalvageListEnter(Sender: TObject);
    procedure fileListEnter(Sender: TObject);
    procedure ncopyBtnClick(Sender: TObject);
    procedure nPrintBtnClick(Sender: TObject);
    procedure purgeBtnClick(Sender: TObject);
    procedure FlagFile1Click(Sender: TObject);
    procedure DeleteFile1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    filePath : string[99] ;
  end;

var
  winFile: TwinFile;

implementation

{$R *.DFM}

uses
  fileFlag,
  list,
  nCopyDlg ;

procedure TwinFile.FormShow(Sender: TObject);
  var
    ncursor : TCursor ;
  begin
    ncursor := screen.cursor ;
    screen.cursor := crHourglass ;
    if (length(alltrim(filePath)) < 2) then
      filePath := 'z:.\' ;
    dirPath.text := setPath(filePath) ;
    try
      { Add to Salvage List }
      salvageList.items.clear ;
      salvageList.items.addStrings(
           getDeletedFileList(getPrimaryServerID,filePath)) ;
      if (salvageList.items.count > 0) then
        begin
          salvageList.enabled    := true ;
          salvageList.itemIndex  := 0    ;
          delFileInfoBtn.enabled := true ;
          purgeBtn.enabled       := true ;
          delFileInfoBtnClick(sender) ;
          delFileInfoBtn.setfocus ;
        end
      else
        begin
          delFileInfoBtn.enabled := false ;
          purgeBtn.enabled       := false ;
          salvageList.enabled := false ;
          salvageList.items.add('<No Deleted Files in ' + filePath  + '>');
        end;
      { Add files to FileList }
      fileList.items.clear ;
      fileList.items.addStrings(getVolFileList(filePath + '*'));{see also:getVolDirList}
      if (fileList.items.count > 0) then                            
        begin
          fileList.itemIndex  := 0 ;
          fileList.enabled    := true ;
          fileInfoBtn.enabled := true ;
          nCopyBtn.enabled    := true ;
          nPrintBtn.enabled   := true ;
          if (salvageList.items[0][1] = '<') then
            begin
              fileInfoBtnClick(sender) ;
              fileInfoBtn.setfocus ;
            end;
         end
      else
        begin
          fileInfoBtn.enabled := false ;
          nPrintBtn.enabled   := false ;
          nCopyBtn.enabled    := false ;
          fileList.items.add('<No Files in ' + filePath  + '>');
        end;
     finally
       screen.cursor := ncursor ;
     end;
  end;

procedure TwinFile.bSalvageClick(Sender: TObject);
  var
    ctemp : string ;
  begin
    ctemp := filePath + 'erase.me' ;
    if fileExists(ctemp) and 
       yesNoBox(filePath + 'ERASE.ME;OverWrite Existing File?') then
      {$IFDEF WIN32}
      deleteFile(PChar(ctemp)) ;
      {$ELSE}
      deleteFile(ctemp) ;
      {$ENDIF}
    if (not fileExists(ctemp)) then 
      begin
        if salvage(getPrimaryServerID,
                   filePath + salvageList.items[salvageList.itemIndex],
                   filePath + 'erase.me') then
          okbox('File Salvaged to ' + ctemp) 
        else
          alertBox('Salvage Failed!') ;
      end;
  end;

procedure TwinFile.delFileInfoBtnClick(Sender: TObject);
  var
    deletedFileInfo : TNWDeletedFileInfo ;
  begin
    fileOwner.text    := 'Unknown' ;
    fileModified.text := 'N/A'     ;
    fileSize.text     := 'Unknown' ;
    fileCreated.text  := 'Unknown' ;
    fileUpdated.text  := 'Unknown' ;
    deleteDate.text   := 'Unknown' ;
    deleteBy.text     := 'Unknown' ;
    archiveBy.text    := 'Unknown' ;
    bSalvage.enabled  := true      ;
    if getDeletedFileInfo(filePath +
                          salvageList.items[salvageList.itemIndex],
                          deletedFileInfo) then 
      begin
        fileOwner.text   := deletedFileInfo.ownerID                    ;
        fileSize.text    := intToStr(deletedFileInfo.fileSize)         ;
        fileCreated.text := dateToStr(deletedFileInfo.creationDate)    ;
        fileUpdated.text := dateToStr(deletedFileInfo.updateDateTime)  ;
        deleteDate.text  := dateToStr(deletedFileInfo.deletedDateTime) ;
        deleteBy.text    := deletedFileInfo.deletedBy ;
        archiveBy.text   := deletedFileInfo.lastArchivedBy ;
      end;
  end;

procedure TwinFile.fileInfoBtnClick(Sender: TObject);
  var
    fileInfo : TNWFileInfo ;
  begin
    fileOwner.text    := 'Unknown' ;
    fileModified.text := 'Unknown' ;
    fileSize.text     := 'Unknown' ;
    fileCreated.text  := 'Unknown' ;
    fileUpdated.text  := 'Unknown' ;
    deleteDate.text   := 'N/A'     ;
    deleteBy.text     := 'N/A'     ;
    archiveBy.text    := 'Unknown' ;
    bSalvage.enabled  := false     ;
    if getFileInfo(filePath + fileList.items[fileList.itemIndex],
                   fileInfo) then 
      begin
        fileOwner.text    := fileInfo.ownerID ;
        fileUpdated.text  := dateToStr(fileInfo.updatedDateTime);
        fileModified.text := dateToStr(fileInfo.lastModifyDate) ;
        fileSize.text     := intToStr(fileInfo.fileSize)        ;
        fileCreated.text  := dateToStr(fileInfo.creationDate)   ;
        archiveBy.text    := fileInfo.lastArchivedBy            ;
      end;
    {if getDirectoryInfo('sys:public',fileInfo) then
      okBox('Example of Obtaining Directory Information') ; }
  end;

procedure TwinFile.bRefreshClick(Sender: TObject);
  begin
    filePath := setPath(dirPath.text) ;
    if dirPath.modified then
      formShow(self.owner) ;
  end;

procedure TwinFile.SalvageListEnter(Sender: TObject);
  begin
    bSalvage.enabled := (salvageList.items.count > 0) ;
  end;

procedure TwinFile.fileListEnter(Sender: TObject);
  begin
    bSalvage.enabled := false ;
  end;

procedure TwinFile.ncopyBtnClick(Sender: TObject);
  begin
    try
      application.createForm(TWinNCopyDlg,winNCopyDlg) ;
      winNCopyDlg.inFile.text := setPath(dirPath.text) +
                                 fileList.items[fileList.itemIndex] ;
      winNCopyDlg.outFile.text := setPath(dirPath.text) ;
      winNCopyDlg.showModal ;               
    finally
      winNCopyDlg.free ;
      winNCopyDlg := nil ;
    end;
  end;

procedure TwinFile.nPrintBtnClick(Sender: TObject);
  var
    nloop    : integer ;
    cfile    : string ;
    tempList : TStringList ;
  begin
    cfile := setPath(dirPath.text) + fileList.items[fileList.itemIndex] ;
    try
      application.createForm(TWinList,winList) ;
      with winList do begin
        caption         := 'Select Queue to Print File: ' + cfile ;
        button2.visible := false ;
        button3.visible := false ;
        button1.caption := '&Select' ;
        button4.caption := '&Cancel' ;
        button1.modalResult := mrOK ;
        button4.modalResult := mrCancel ;
        {fill list w/queue names}
        tempList := getBinderyList(0,nw_printQ) ;
        listGrid.colCount := 0 ;
        for nloop := 0 to (tempList.count -1) do 
          with listGrid do begin
            rowCount := nloop+1 ;
            cells[0,nloop] := tempList[nloop] ;
          end;
        showModal ;
        if (modalResult = mrOK) then
          begin
            if NPrint(0,listGrid.cells[0,listGrid.row],cfile) then
              okbox(cfile + ';Printed Successfully!')
            else 
              alertBox(cfile + ';Not Printed!;;Check Queue Access Rights') ;
          end;  
      end;
    finally
      winList.free ;
      winList := nil ;
      tempList.free ;
    end;
  end;

procedure TwinFile.purgeBtnClick(Sender: TObject);
  var
    cPath : string ;
  begin
    cPath := extractFilePath(dirPath.text) ;
    if noYesBox(cPath + ';;Purging All Deleted Files in Directory;;Are You Sure?') then
      begin
        if purgeAllFiles(0,cPath) then
          okBox('Purge Operation Completed')
        else
          alertBox('Could Not Purge All Files in Directory;;' + 
                   'Check Your Directory Access Rights') ;
        {refresh lists}
        formShow(self) ;
      end;
  end;


procedure TwinFile.FlagFile1Click(Sender: TObject);
  var
    fileName : string ;
  begin
    with fileList do begin
      if (items.count < 1) then
        exit 
      else if (itemIndex < 0) then
        itemIndex := 0 ;
      fileName := setPath(dirPath.text) + items[itemIndex] ;  
    end;  
    application.createForm(TWinFileFlag,winFileFlag) ;
    try
      winFileFlag.fileName := fileName ;
      with winFileFlag do begin
        if (not getFileFlags(0,fileName,fileFlags)) then
          begin
            alertBox(fileName + ';;Unable to Obtain File Flags') ;
            exit ;
          end;
        with fileList do
          caption := extractFileName(fileName) ;
        checkReadOnly.checked  := fileFlags.readOnly ;
        checkShareable.checked := fileFlags.shareable ;
        checkArchive.checked   := fileFlags.needsArchive ;
        checkHidden.checked    := fileFlags.hidden ;
        checkSystem.checked    := fileFlags.system ;
        checkExecute.checked   := fileFlags.executeOnly ;
        showModal ;
      end;
    finally
      winFileFlag.free ;
      winFileFlag := nil ;
    end;
  end;

procedure TwinFile.DeleteFile1Click(Sender: TObject);
  var
    fileName : string ;
  begin
    with fileList do begin
      if (items.count < 1) then 
        exit 
      else if (itemIndex < 0) then
        itemIndex := 0 ;  
      fileName := items[itemIndex] ;
    end;  
    if noYesBox(fileName + 
                ';;Permanently Deleting File;Are You Sure?') then
      begin          
        {$IFDEF Win32}          
          deletefile(PChar(setPath(dirPath.text) + fileName)) ;
        {$ELSE}
          deletefile(setPath(dirPath.text) + fileName) ;
        {$ENDIF}
        if fileExists(setPath(dirPath.text) + fileName) then
          alertBox(fileName + ';;Error Deleting File;Check Access Rights/Flags and Try Again') 
        else
          begin
            okBox('File Deleted SuccessFully') ;
            formShow(sender) ;
          end;  
      end;
      
  end;

end.
